// 跨境翻译宝配置管理
// 自动判断开发/生产环境 (Chrome 插件环境下 process.env.NODE_ENV 可能不可用，使用简单判断)

const IS_DEV = false; // 发布时请改为 false

export const CONFIG = {
  // API 基础地址
  API_BASE_URL: IS_DEV 
    ? 'http://localhost:3000' 
    : 'https://kuajing-fanyi.vercel.app', // ⚠️ 请确保这里是您绑定好的自定义域名 (推荐) 或 Vercel 域名

  // API 路径
  ENDPOINTS: {
    TRANSLATE: '/api/translate'
  },

  // 获取完整 API 地址
  getTranslateUrl() {
    return `${this.API_BASE_URL}${this.ENDPOINTS.TRANSLATE}`;
  }
};
